// vim:set noet cinoptions= sw=4 ts=4:
// This file is part of the eix project and distributed under the
// terms of the GNU General Public License v2.
//
// Copyright (c)
//   Martin Väth <martin@mvath.de>

#include "eixTk/stringlist.h"
#include <config.h>  // IWYU pragma: keep

#include <string>

#include "eixTk/dialect.h"
#include "eixTk/likely.h"
#include "eixTk/null.h"
#include "eixTk/stringtypes.h"

void StringListContent::finalize() {
	if(likely(m_list.empty())) {
		return;
	}
	if(unlikely(m_list[0].empty()) || unlikely(m_list[m_list.size() - 1].empty())) {
		WordVec cp;
		WordVec::const_iterator it(m_list.begin());
		while(unlikely(it->empty())) {
			if(unlikely((++it) == m_list.end())) {
				m_list.clear();
				return;
			}
		}
		for(; likely(it != m_list.end()); ++it) {
			for(WordVec::const_iterator r(it); unlikely(r->empty()); ) {
				if(unlikely((++r) == m_list.end())) {
					m_list = MOVE(cp);
					return;
				}
			}
			cp.PUSH_BACK(MOVE(*it));
		}
		m_list = MOVE(cp);
	}
}

#ifdef STRINGLIST_FREE
StringList::StringList(const StringList& s) {
	ptr = s.ptr;
	if(ptr != NULLPTR) {
		++(ptr->usage);
	}
}

StringList& StringList::operator=(const StringList& s) {
	if(ptr != s.ptr) {
		if(s.ptr != NULLPTR) {
			++(s.ptr->usage);
		}
		if(ptr != NULLPTR) {
			if(--(ptr->usage) == 0) {
				delete ptr;
			}
		}
		ptr = s.ptr;
	}
	return *this;
}

StringList::~StringList() {
	if(ptr != NULLPTR) {
		if(--(ptr->usage) == 0) {
			delete ptr;
		}
	}
}
#endif

void StringList::finalize() {
	if(ptr != NULLPTR) {
		ptr->finalize();
		if(ptr->empty()) {
			delete ptr;
			ptr = NULLPTR;
		}
	}
}

void StringList::push_back(const std::string& s) {
	if(ptr == NULLPTR) {
		ptr = new StringListContent;
#ifdef STRINGLIST_FREE
		ptr->usage = 1;
#endif
	}
	ptr->push_back(s);
}

#ifdef HAVE_MOVE
void StringList::push_back(std::string&& s) {
	if(ptr == NULLPTR) {
		ptr = new StringListContent;
#ifdef STRINGLIST_FREE
		ptr->usage = 1;
#endif
	}
	ptr->push_back(s);
}
#endif
